import React, { useState, useEffect, useRef } from 'react'
import './Chatbot.css'

const Chatbot = () => {
  const [messages, setMessages] = useState([])
  const [inputValue, setInputValue] = useState('')
  const messagesEndRef = useRef(null)

  const faqs = {
    'hello': 'Hello! How can I help you today?',
    'hi': 'Hi there! What can I assist you with?',
    'products': 'We offer a wide range of products including electronics, clothing, and home goods. Is there a specific category you\'re interested in?',
    'order status': 'To check your order status, please provide your order number.',
    'return policy': 'Our return policy allows returns within 30 days of purchase with original receipt. Would you like help initiating a return?',
    'contact support': 'You can reach our support team at support@example.com or call us at (555) 123-4567.',
    'shipping': 'We offer standard shipping (3-5 days) and express shipping (1-2 days). Shipping costs vary by location.',
    'payment methods': 'We accept Visa, Mastercard, American Express, PayPal, and Apple Pay.',
    'default': 'I\'m sorry, I didn\'t understand that. Could you please rephrase your question? Here are some things I can help with: products, order status, return policy, shipping, payment methods.'
  }

  const handleSendMessage = () => {
    if (inputValue.trim() === '') return

    // Add user message
    setMessages(prev => [...prev, { text: inputValue, sender: 'user' }])
    
    // Process and add bot response
    const userMessage = inputValue.toLowerCase()
    let response = faqs.default
    
    Object.keys(faqs).forEach(key => {
      if (userMessage.includes(key)) {
        response = faqs[key]
      }
    })

    setTimeout(() => {
      setMessages(prev => [...prev, { text: response, sender: 'bot' }])
    }, 500)

    setInputValue('')
  }

  const handleKeyPress = (e) => {
    if (e.key === 'Enter') {
      handleSendMessage()
    }
  }

  useEffect(() => {
    // Initial greeting
    setMessages([{ text: 'Hello! How can I help you today?', sender: 'bot' }])
  }, [])

  useEffect(() => {
    messagesEndRef.current?.scrollIntoView({ behavior: 'smooth' })
  }, [messages])

  return (
    <div className="chatbot-container">
      <div className="chatbot-messages">
        {messages.map((message, index) => (
          <div key={index} className={`message ${message.sender}`}>
            {message.text}
          </div>
        ))}
        <div ref={messagesEndRef} />
      </div>
      <div className="chatbot-input">
        <input
          type="text"
          value={inputValue}
          onChange={(e) => setInputValue(e.target.value)}
          onKeyPress={handleKeyPress}
          placeholder="Type your message here..."
        />
        <button onClick={handleSendMessage}>Send</button>
      </div>
    </div>
  )
}

export default Chatbot
