import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import { ThemeProvider } from '@emotion/react'
import { createTheme } from '@mui/material'
import NavBar from './components/NavBar'
import Dashboard from './pages/Dashboard'
import Customers from './pages/Customers'
import Policies from './pages/Policies'
import Claims from './pages/Claims'
import Reports from './pages/Reports'

const theme = createTheme({
  palette: {
    primary: {
      main: '#008b8b', // dark cyan
    },
    background: {
      default: '#f5f5f5', // whitesmoke
    },
  },
})

function App() {
  return (
    <ThemeProvider theme={theme}>
      <Router>
        <NavBar />
        <Routes>
          <Route path="/" element={<Dashboard />} />
          <Route path="/customers" element={<Customers />} />
          <Route path="/policies" element={<Policies />} />
          <Route path="/claims" element={<Claims />} />
          <Route path="/reports" element={<Reports />} />
        </Routes>
      </Router>
    </ThemeProvider>
  )
}

export default App
