import { AppBar, Toolbar, Typography, Button } from '@mui/material'
import { Link } from 'react-router-dom'

export default function NavBar() {
  return (
    <AppBar position="static">
      <Toolbar>
        <Typography variant="h6" component="div" sx={{ flexGrow: 1 }}>
          Insurance Management
        </Typography>
        <Button color="inherit" component={Link} to="/">
          Dashboard
        </Button>
        <Button color="inherit" component={Link} to="/customers">
          Customers
        </Button>
        <Button color="inherit" component={Link} to="/policies">
          Policies
        </Button>
        <Button color="inherit" component={Link} to="/claims">
          Claims
        </Button>
        <Button color="inherit" component={Link} to="/reports">
          Reports
        </Button>
      </Toolbar>
    </AppBar>
  )
}
