import { useState } from 'react'
import './App.css'

function App() {
  const [polls, setPolls] = useState([
    {
      id: 1,
      question: 'What is your favorite programming language?',
      options: [
        { id: 1, text: 'JavaScript', votes: 0 },
        { id: 2, text: 'Python', votes: 0 },
        { id: 3, text: 'Java', votes: 0 },
        { id: 4, text: 'C#', votes: 0 },
      ],
    },
    {
      id: 2,
      question: 'Which framework do you prefer for frontend?',
      options: [
        { id: 1, text: 'React', votes: 0 },
        { id: 2, text: 'Vue', votes: 0 },
        { id: 3, text: 'Angular', votes: 0 },
        { id: 4, text: 'Svelte', votes: 0 },
      ],
    },
  ])
  const [activePoll, setActivePoll] = useState(0)
  const [selectedOption, setSelectedOption] = useState(null)
  const [hasVoted, setHasVoted] = useState(false)

  const handleVote = () => {
    if (selectedOption === null) return

    const updatedPolls = [...polls]
    updatedPolls[activePoll].options[selectedOption].votes += 1
    setPolls(updatedPolls)
    setHasVoted(true)
  }

  const resetPoll = () => {
    setSelectedOption(null)
    setHasVoted(false)
  }

  return (
    <div className="app">
      <h1 className="header">Polling App</h1>
      
      <div className="poll-container">
        <h2>{polls[activePoll].question}</h2>
        
        {!hasVoted ? (
          <div className="options">
            {polls[activePoll].options.map((option, index) => (
              <div 
                key={option.id}
                className={`option ${selectedOption === index ? 'selected' : ''}`}
                onClick={() => setSelectedOption(index)}
              >
                {option.text}
              </div>
            ))}
            <button className="vote-button" onClick={handleVote} disabled={selectedOption === null}>
              Vote
            </button>
          </div>
        ) : (
          <div className="results">
            <h3>Results:</h3>
            {polls[activePoll].options.map(option => (
              <div key={option.id} className="result-item">
                <span>{option.text}:</span>
                <span>{option.votes} votes</span>
              </div>
            ))}
            <button className="reset-button" onClick={resetPoll}>
              Vote Again
            </button>
          </div>
        )}
      </div>

      <div className="poll-selector">
        {polls.map((poll, index) => (
          <button
            key={poll.id}
            className={`poll-tab ${activePoll === index ? 'active' : ''}`}
            onClick={() => {
              setActivePoll(index)
              resetPoll()
            }}
          >
            Poll {index + 1}
          </button>
        ))}
      </div>
    </div>
  )
}

export default App
