import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import { ThemeProvider, createTheme } from '@mui/material/styles'
import { CssBaseline } from '@mui/material'
import HomePage from './pages/HomePage'
import PromotionsPage from './pages/PromotionsPage'
import SharePromotionPage from './pages/SharePromotionPage'
import AdminDashboard from './pages/AdminDashboard'
import NavBar from './components/NavBar'

const theme = createTheme({
  palette: {
    primary: {
      main: '#228B22', // Forest green
    },
    secondary: {
      main: '#FFFFF0', // Ivory
    },
  },
})

function App() {
  return (
    <ThemeProvider theme={theme}>
      <CssBaseline />
      <Router>
        <NavBar />
        <Routes>
          <Route path="/" element={<HomePage />} />
          <Route path="/promotions" element={<PromotionsPage />} />
          <Route path="/share" element={<SharePromotionPage />} />
          <Route path="/admin" element={<AdminDashboard />} />
        </Routes>
      </Router>
    </ThemeProvider>
  )
}

export default App
