import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import Home from './pages/Home'
import Contests from './pages/Contests'
import Results from './pages/Results'
import Gallery from './pages/Gallery'
import Register from './pages/Register'
import Navbar from './components/Navbar'

function App() {
  return (
    <Router>
      <Navbar />
      <Routes>
        <Route path="/" element={<Home />} />
        <Route path="/contests" element={<Contests />} />
        <Route path="/results" element={<Results />} />
        <Route path="/gallery" element={<Gallery />} />
        <Route path="/register" element={<Register />} />
      </Routes>
    </Router>
  )
}

export default App
