import { Link } from 'react-router-dom'

const PostCard = ({ post }) => {
  return (
    <div style={{ 
      backgroundColor: 'slategray',
      color: 'white',
      padding: '15px',
      borderRadius: '8px'
    }}>
      <Link to={`/post/${post.id}`}>
        <h3 style={{ margin: '0 0 10px 0' }}>{post.title}</h3>
      </Link>
      <p style={{ margin: '5px 0', fontStyle: 'italic' }}>
        Posted by {post.author} in {post.category} • {post.replyCount} replies
      </p>
      <p style={{ margin: '10px 0 0 0' }}>{post.content.substring(0, 100)}...</p>
    </div>
  )
}

export default PostCard
