import { useParams } from 'react-router-dom'
import { mockPosts, mockReplies } from '../data/mockData'
import ReplyForm from '../components/ReplyForm'
import ReplyCard from '../components/ReplyCard'

const PostDetail = () => {
  const { id } = useParams()
  const post = mockPosts.find(p => p.id === parseInt(id))
  const replies = mockReplies.filter(r => r.postId === parseInt(id))

  if (!post) {
    return <div>Post not found</div>
  }

  return (
    <div style={{ maxWidth: '800px', margin: '0 auto' }}>
      <div style={{ 
        backgroundColor: 'slategray', 
        color: 'white',
        padding: '20px',
        borderRadius: '8px',
        marginBottom: '20px'
      }}>
        <h2>{post.title}</h2>
        <p style={{ fontStyle: 'italic' }}>Posted by {post.author} in {post.category}</p>
        <p>{post.content}</p>
      </div>
      
      <h3 style={{ color: 'slategray' }}>Replies ({replies.length})</h3>
      <ReplyForm postId={post.id} />
      
      <div style={{ display: 'flex', flexDirection: 'column', gap: '15px', marginTop: '20px' }}>
        {replies.map(reply => (
          <ReplyCard key={reply.id} reply={reply} />
        ))}
      </div>
    </div>
  )
}

export default PostDetail
