import { useSearchParams } from 'react-router-dom'
import PostCard from '../components/PostCard'
import { mockPosts } from '../data/mockData'

const SearchResults = () => {
  const [searchParams] = useSearchParams()
  const query = searchParams.get('q') || ''
  const results = mockPosts.filter(post => 
    post.title.toLowerCase().includes(query.toLowerCase()) || 
    post.content.toLowerCase().includes(query.toLowerCase())
  )

  return (
    <div style={{ maxWidth: '1000px', margin: '0 auto' }}>
      <h2 style={{ color: 'slategray' }}>Search Results for "{query}"</h2>
      {results.length > 0 ? (
        <div style={{ display: 'flex', flexDirection: 'column', gap: '15px' }}>
          {results.map(post => (
            <PostCard key={post.id} post={post} />
          ))}
        </div>
      ) : (
        <p>No posts found matching your search.</p>
      )}
    </div>
  )
}

export default SearchResults
