import Database from 'better-sqlite3'
import { v4 as uuidv4 } from 'uuid'

const db = new Database('truth-expose.db')

// Initialize database tables if they don't exist
function initDb() {
  db.exec(`
    CREATE TABLE IF NOT EXISTS reports (
      id TEXT PRIMARY KEY,
      title TEXT NOT NULL,
      content TEXT NOT NULL,
      created_at TEXT DEFAULT CURRENT_TIMESTAMP,
      status TEXT DEFAULT 'pending'
    );
    
    CREATE TABLE IF NOT EXISTS forum_posts (
      id TEXT PRIMARY KEY,
      title TEXT NOT NULL,
      content TEXT NOT NULL,
      created_at TEXT DEFAULT CURRENT_TIMESTAMP,
      author_id TEXT DEFAULT 'anonymous'
    );
    
    CREATE TABLE IF NOT EXISTS news (
      id TEXT PRIMARY KEY,
      title TEXT NOT NULL,
      content TEXT NOT NULL,
      published_at TEXT DEFAULT CURRENT_TIMESTAMP,
      author TEXT DEFAULT 'Editor'
    );
  `)
}

initDb()

export default db
