import { useParams } from 'react-router-dom'
import { FaBed, FaBath, FaRulerCombined, FaArrowLeft } from 'react-icons/fa'
import { Link } from 'react-router-dom'

const PropertyDetails = ({ properties, loading }) => {
  const { id } = useParams()
  const property = properties.find(p => p.id === parseInt(id))

  if (loading) return <div className="loading">Loading property details...</div>
  if (!property) return <div className="not-found">Property not found</div>

  return (
    <div className="property-details">
      <Link to="/" className="back-button">
        <FaArrowLeft /> Back to Listings
      </Link>
      
      <div className="property-gallery">
        <img src={property.image} alt={property.title} />
      </div>
      
      <div className="property-content">
        <h1>{property.title}</h1>
        <p className="address">{property.address}</p>
        <p className="price">${property.price.toLocaleString()}</p>
        
        <div className="property-meta">
          <span><FaBed /> {property.bedrooms} Bedrooms</span>
          <span><FaBath /> {property.bathrooms} Bathrooms</span>
          <span><FaRulerCombined /> {property.sqft} Square Feet</span>
        </div>
        
        <div className="property-description">
          <h2>Description</h2>
          <p>{property.description}</p>
        </div>
      </div>
    </div>
  )
}

export default PropertyDetails
