const PropertyFilter = ({ filters, onFilterChange }) => {
  return (
    <div className="property-filter">
      <h2>Filter Properties</h2>
      <div className="filter-controls">
        <div className="filter-group">
          <label>Min Price</label>
          <input
            type="number"
            name="minPrice"
            value={filters.minPrice}
            onChange={onFilterChange}
            placeholder="$"
          />
        </div>
        
        <div className="filter-group">
          <label>Max Price</label>
          <input
            type="number"
            name="maxPrice"
            value={filters.maxPrice}
            onChange={onFilterChange}
            placeholder="$"
          />
        </div>
        
        <div className="filter-group">
          <label>Bedrooms</label>
          <input
            type="number"
            name="bedrooms"
            value={filters.bedrooms}
            onChange={onFilterChange}
            placeholder="Min"
          />
        </div>
        
        <div className="filter-group">
          <label>Bathrooms</label>
          <input
            type="number"
            name="bathrooms"
            value={filters.bathrooms}
            onChange={onFilterChange}
            placeholder="Min"
          />
        </div>
      </div>
    </div>
  )
}

export default PropertyFilter
