export const formatPrice = (price) => {
  return new Intl.NumberFormat('en-US', {
    style: 'currency',
    currency: 'USD',
    maximumFractionDigits: 0
  }).format(price)
}

export const filterProperties = (properties, filters) => {
  return properties.filter(property => {
    return (
      (filters.minPrice === '' || property.price >= Number(filters.minPrice)) &&
      (filters.maxPrice === '' || property.price <= Number(filters.maxPrice)) &&
      (filters.bedrooms === '' || property.bedrooms >= Number(filters.bedrooms)) &&
      (filters.bathrooms === '' || property.bathrooms >= Number(filters.bathrooms))
    )
  })
}
