import { useState } from 'react'
import { useNavigate } from 'react-router-dom'
import './ProductSearch.css'

export default function ProductSearch({ setSearchParams }) {
  const [category, setCategory] = useState('electronics')
  const [productName, setProductName] = useState('')
  const [states, setStates] = useState(['CA', 'NY', 'TX'])
  const navigate = useNavigate()

  const handleSubmit = (e) => {
    e.preventDefault()
    const params = { category, productName, states }
    setSearchParams(params)
    navigate('/results')
  }

  return (
    <div className="search-container">
      <h2>Find the Best Prices Across States</h2>
      <form onSubmit={handleSubmit} className="search-form">
        <div className="form-group">
          <label>Product Category:</label>
          <select 
            value={category} 
            onChange={(e) => setCategory(e.target.value)}
            className="form-control"
          >
            <option value="electronics">Electronics</option>
            <option value="groceries">Groceries</option>
            <option value="clothing">Clothing</option>
            <option value="home">Home Goods</option>
          </select>
        </div>
        
        <div className="form-group">
          <label>Product Name:</label>
          <input
            type="text"
            value={productName}
            onChange={(e) => setProductName(e.target.value)}
            placeholder="e.g. iPhone 15, Organic Milk"
            className="form-control"
          />
        </div>
        
        <div className="form-group">
          <label>States to Compare:</label>
          <div className="states-checkbox">
            {['CA', 'NY', 'TX', 'FL', 'IL'].map(state => (
              <label key={state}>
                <input
                  type="checkbox"
                  checked={states.includes(state)}
                  onChange={() => {
                    if (states.includes(state)) {
                      setStates(states.filter(s => s !== state))
                    } else {
                      setStates([...states, state])
                    }
                  }}
                />
                {state}
              </label>
            ))}
          </div>
        </div>
        
        <button type="submit" className="search-button">
          Compare Prices
        </button>
      </form>
    </div>
  )
}
