import { useEffect, useState } from 'react'
import { useLocation } from 'react-router-dom'
import './ResultsPage.css'

export default function ResultsPage() {
  const [loading, setLoading] = useState(true)
  const [products, setProducts] = useState([])
  const location = useLocation()

  useEffect(() => {
    // Simulate API call
    setTimeout(() => {
      const mockProducts = [
        {
          id: 1,
          name: 'Sample Product 1',
          price: 299.99,
          state: 'CA',
          supplier: 'Best Electronics',
          quantity: 10
        },
        {
          id: 2,
          name: 'Sample Product 2',
          price: 199.99,
          state: 'NY',
          supplier: 'Tech Haven',
          quantity: 5
        },
        {
          id: 3,
          name: 'Sample Product 3',
          price: 249.99,
          state: 'TX',
          supplier: 'Gadget World',
          quantity: 8
        }
      ]
      setProducts(mockProducts)
      setLoading(false)
    }, 1000)
  }, [])

  if (loading) {
    return <div className="loading">Loading results...</div>
  }

  return (
    <div className="results-container">
      <h2>Price Comparison Results</h2>
      
      <div className="filters">
        <select className="filter-control">
          <option>Sort by: Lowest Price</option>
          <option>Sort by: Highest Price</option>
          <option>Sort by: State</option>
        </select>
      </div>
      
      <div className="product-grid">
        {products.map(product => (
          <div key={product.id} className="product-card">
            <h3>{product.name}</h3>
            <div className="product-price">${product.price.toFixed(2)}</div>
            <div className="product-details">
              <p><strong>State:</strong> {product.state}</p>
              <p><strong>Supplier:</strong> {product.supplier}</p>
              <p><strong>Quantity:</strong> {product.quantity}</p>
            </div>
            <button className="view-button">View Details</button>
          </div>
        ))}
      </div>
    </div>
  )
}
