import { useState } from 'react'
import CustomizationForm from './components/CustomizationForm'
import DesignPreview from './components/DesignPreview'
import OrderSummary from './components/OrderSummary'
import './App.scss'

function App() {
  const [step, setStep] = useState(1)
  const [shirtData, setShirtData] = useState({
    model: '',
    fabric: '',
    measurements: {},
    design: null
  })

  const handleSubmit = (data) => {
    setShirtData({...shirtData, ...data})
    setStep(2)
  }

  const confirmDesign = (design) => {
    setShirtData({...shirtData, design})
    setStep(3)
  }

  return (
    <div className="app-container">
      {step === 1 && <CustomizationForm onSubmit={handleSubmit} />}
      {step === 2 && <DesignPreview shirtData={shirtData} onConfirm={confirmDesign} />}
      {step === 3 && <OrderSummary shirtData={shirtData} />}
    </div>
  )
}

export default App
