import { useState } from 'react'
import './CustomizationForm.scss'

const CustomizationForm = ({ onSubmit }) => {
  const [formData, setFormData] = useState({
    model: 'classic',
    fabric: 'cotton',
    chest: '',
    waist: '',
    length: ''
  })

  const handleChange = (e) => {
    const { name, value } = e.target
    setFormData({...formData, [name]: value})
  }

  const handleSubmit = (e) => {
    e.preventDefault()
    const measurements = {
      chest: formData.chest,
      waist: formData.waist,
      length: formData.length
    }
    onSubmit({
      model: formData.model,
      fabric: formData.fabric,
      measurements
    })
  }

  return (
    <form className="customization-form" onSubmit={handleSubmit}>
      <h2>Customize Your Shirt</h2>
      
      <div className="form-group">
        <label>Shirt Model</label>
        <select name="model" value={formData.model} onChange={handleChange}>
          <option value="classic">Classic</option>
          <option value="slim">Slim Fit</option>
          <option value="relaxed">Relaxed Fit</option>
        </select>
      </div>

      <div className="form-group">
        <label>Fabric Type</label>
        <select name="fabric" value={formData.fabric} onChange={handleChange}>
          <option value="cotton">100% Cotton</option>
          <option value="linen">Linen</option>
          <option value="polycotton">Poly-Cotton Blend</option>
        </select>
      </div>

      <div className="form-group">
        <label>Chest Measurement (inches)</label>
        <input 
          type="number" 
          name="chest" 
          value={formData.chest} 
          onChange={handleChange} 
          required 
        />
      </div>

      <div className="form-group">
        <label>Waist Measurement (inches)</label>
        <input 
          type="number" 
          name="waist" 
          value={formData.waist} 
          onChange={handleChange} 
          required 
        />
      </div>

      <div className="form-group">
        <label>Length Measurement (inches)</label>
        <input 
          type="number" 
          name="length" 
          value={formData.length} 
          onChange={handleChange} 
          required 
        />
      </div>

      <button type="submit" className="submit-btn">Preview Design</button>
    </form>
  )
}

export default CustomizationForm
