import { useState } from 'react'
import './DesignPreview.scss'

const DesignPreview = ({ shirtData, onConfirm }) => {
  const [design, setDesign] = useState(null)

  const generateDesign = () => {
    // This would be replaced with actual design generation logic
    const generatedDesign = {
      preview: `shirt-${shirtData.model}-${shirtData.fabric}.png`,
      price: calculatePrice(shirtData)
    }
    setDesign(generatedDesign)
  }

  const calculatePrice = (data) => {
    // Simple pricing logic
    const basePrice = 29.99
    const fabricMultiplier = {
      cotton: 1,
      linen: 1.5,
      polycotton: 0.8
    }
    return (basePrice * fabricMultiplier[data.fabric]).toFixed(2)
  }

  return (
    <div className="design-preview">
      <h2>Your Custom Shirt Design</h2>
      
      <div className="preview-container">
        {design ? (
          <img src={design.preview} alt="Shirt design preview" />
        ) : (
          <button onClick={generateDesign}>Generate Design Preview</button>
        )}
      </div>

      {design && (
        <>
          <div className="design-details">
            <p>Model: {shirtData.model}</p>
            <p>Fabric: {shirtData.fabric}</p>
            <p>Price: ${design.price}</p>
          </div>
          <button onClick={() => onConfirm(design)}>Confirm Design</button>
        </>
      )}
    </div>
  )
}

export default DesignPreview
