import './OrderSummary.scss'

const OrderSummary = ({ shirtData }) => {
  return (
    <div className="order-summary">
      <h2>Order Summary</h2>
      
      <div className="summary-details">
        <h3>Your Custom Shirt</h3>
        <p>Model: {shirtData.model}</p>
        <p>Fabric: {shirtData.fabric}</p>
        <p>Measurements:</p>
        <ul>
          {Object.entries(shirtData.measurements).map(([key, value]) => (
            <li key={key}>{key}: {value}"</li>
          ))}
        </ul>
        <p>Price: ${shirtData.design.price}</p>
      </div>

      <div className="payment-section">
        <h3>Payment Information</h3>
        {/* Payment form would go here */}
        <button>Proceed to Payment</button>
      </div>
    </div>
  )
}

export default OrderSummary
