import { Link } from 'react-router-dom'
import { FaSearch, FaBed, FaMapMarkerAlt, FaStar } from 'react-icons/fa'

export default function Home() {
  return (
    <div className="max-w-7xl mx-auto py-8 px-4">
      <div className="bg-white p-8 rounded-lg shadow-md text-center mb-12">
        <h1 className="text-4xl font-bold mb-4 text-[maroon]">Find Your Perfect Short-Term Rental</h1>
        <p className="text-lg mb-8">Discover comfortable apartments in prime locations for your next trip</p>
        
        <div className="max-w-2xl mx-auto">
          <div className="bg-gray-100 p-4 rounded-lg">
            <p className="text-sm mb-2">Search by location, dates, and preferences</p>
            <div className="flex">
              <input 
                type="text" 
                placeholder="Where are you going?" 
                className="flex-1 p-3 border rounded-l focus:outline-none focus:ring-2 focus:ring-[maroon]"
              />
              <Link 
                to="/apartments" 
                className="bg-[maroon] text-white px-6 py-3 rounded-r hover:bg-opacity-90 flex items-center"
              >
                <FaSearch className="mr-2" /> Search
              </Link>
            </div>
          </div>
        </div>
      </div>
      
      <div className="mt-16">
        <h2 className="text-2xl font-bold mb-6 text-[maroon]">Featured Apartments</h2>
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
          {[
            {
              id: 1,
              title: "Luxury Downtown Loft",
              location: "New York",
              price: 250,
              rating: 4.9
            },
            {
              id: 2,
              title: "Beachfront Condo",
              location: "Miami",
              price: 180,
              rating: 4.7
            },
            {
              id: 3,
              title: "Cozy Mountain Cabin",
              location: "Denver",
              price: 150,
              rating: 4.8
            }
          ].map(apartment => (
            <div key={apartment.id} className="bg-white p-4 rounded-lg shadow-md hover:shadow-lg transition-shadow">
              <div className="bg-gray-200 h-48 mb-4 rounded"></div>
              <div className="flex justify-between items-start">
                <div>
                  <h3 className="font-semibold">{apartment.title}</h3>
                  <p className="text-gray-600 text-sm flex items-center">
                    <FaMapMarkerAlt className="mr-1" /> {apartment.location}
                  </p>
                </div>
                <div className="flex items-center">
                  <FaStar className="text-yellow-400 mr-1" />
                  <span>{apartment.rating}</span>
                </div>
              </div>
              <div className="mt-2">
                <span className="font-bold text-[maroon]">${apartment.price}</span>
                <span className="text-gray-500 text-sm"> / night</span>
              </div>
            </div>
          ))}
        </div>
      </div>

      <div className="mt-16 bg-white p-8 rounded-lg shadow-md">
        <h2 className="text-2xl font-bold mb-6 text-[maroon] text-center">Why Choose UrbanStay?</h2>
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {[
            {
              icon: <FaBed className="text-3xl mb-4 text-[maroon]" />,
              title: "Comfortable Stays",
              description: "Our apartments are carefully selected for comfort and quality."
            },
            {
              icon: <FaMapMarkerAlt className="text-3xl mb-4 text-[maroon]" />,
              title: "Prime Locations",
              description: "Stay in the best neighborhoods close to attractions."
            },
            {
              icon: <FaStar className="text-3xl mb-4 text-[maroon]" />,
              title: "Verified Reviews",
              description: "Read authentic reviews from previous guests."
            }
          ].map((feature, index) => (
            <div key={index} className="text-center">
              <div className="flex justify-center">{feature.icon}</div>
              <h3 className="text-xl font-semibold mb-2">{feature.title}</h3>
              <p className="text-gray-600">{feature.description}</p>
            </div>
          ))}
        </div>
      </div>
    </div>
  )
}
