import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import { ThemeProvider, createTheme } from '@mui/material/styles'
import CssBaseline from '@mui/material/CssBaseline'
import Home from './pages/Home'
import DomainSearch from './pages/DomainSearch'
import UserDashboard from './pages/UserDashboard'
import AdminPanel from './pages/AdminPanel'
import Navbar from './components/Navbar'

const theme = createTheme({
  palette: {
    background: {
      default: '#fdf5e6', // old lace
    },
    primary: {
      main: '#bc8f8f', // rosy brown
    },
  },
})

function App() {
  return (
    <ThemeProvider theme={theme}>
      <CssBaseline />
      <Router>
        <Navbar />
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/search" element={<DomainSearch />} />
          <Route path="/dashboard" element={<UserDashboard />} />
          <Route path="/admin" element={<AdminPanel />} />
        </Routes>
      </Router>
    </ThemeProvider>
  )
}

export default App
