import { Card, CardContent, Typography, Button, Stack } from '@mui/material'

export default function DomainCard({ domain }) {
  return (
    <Card>
      <CardContent>
        <Typography variant="h5" component="div">
          {domain.name}
        </Typography>
        <Typography sx={{ mb: 1.5 }} color="text.secondary">
          {domain.status}
        </Typography>
        <Typography variant="body2">
          Price: ${domain.price}/month
        </Typography>
        <Stack direction="row" spacing={2} sx={{ mt: 2 }}>
          <Button variant="contained" size="small" color="primary">
            Lease Now
          </Button>
          <Button variant="outlined" size="small">
            Details
          </Button>
        </Stack>
      </CardContent>
    </Card>
  )
}
