import { Container, Typography, Button } from '@mui/material'
import { Link } from 'react-router-dom'

export default function Home() {
  return (
    <Container maxWidth="lg" sx={{ py: 4 }}>
      <Typography variant="h3" gutterBottom>
        Welcome to DomainLease
      </Typography>
      <Typography variant="body1" paragraph>
        Rent premium domains for your projects without the long-term commitment.
      </Typography>
      <Button
        variant="contained"
        color="primary"
        component={Link}
        to="/search"
        sx={{ mt: 2 }}
      >
        Browse Domains
      </Button>
    </Container>
  )
}
