import styled from 'styled-components'
import { Link } from 'react-router-dom'
import { FaShoppingCart } from 'react-icons/fa'

const Nav = styled.nav`
  background-color: #5f9ea0;
  padding: 1rem 2rem;
  display: flex;
  justify-content: space-between;
  align-items: center;
  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
`

const NavLinks = styled.div`
  display: flex;
  gap: 1.5rem;
`

const NavLink = styled(Link)`
  color: white;
  text-decoration: none;
  font-weight: 500;
  &:hover {
    text-decoration: underline;
  }
`

const CartIcon = styled(Link)`
  color: white;
  font-size: 1.5rem;
  position: relative;
`

export default function Navbar() {
  return (
    <Nav>
      <NavLink to="/">Leadership Consulting</NavLink>
      <NavLinks>
        <NavLink to="/services">Services</NavLink>
        <NavLink to="/workshops">Workshops</NavLink>
        <NavLink to="/classes">Classes</NavLink>
        <NavLink to="/podcasts">Podcasts</NavLink>
        <NavLink to="/blog">Blog</NavLink>
        <CartIcon to="/cart">
          <FaShoppingCart />
        </CartIcon>
      </NavLinks>
    </Nav>
  )
}
