import styled from 'styled-components'
import { Button } from './shared'

const Card = styled.div`
  background-color: white;
  border-radius: 8px;
  padding: 1.5rem;
  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
  border: 1px solid #5f9ea0;
`

const Title = styled.h3`
  color: #5f9ea0;
  margin-bottom: 0.5rem;
`

const Price = styled.p`
  font-size: 1.2rem;
  font-weight: bold;
  margin: 1rem 0;
`

export default function ServiceCard({ service }) {
  return (
    <Card>
      <Title>{service.title}</Title>
      <Price>${service.price}</Price>
      <Button>Add to Cart</Button>
    </Card>
  )
}
