import { BrowserRouter, Routes, Route } from 'react-router-dom'
import { ThemeProvider, createTheme } from '@mui/material/styles'
import Dashboard from './pages/Dashboard'
import PolicyDetail from './pages/PolicyDetail'
import Navbar from './components/Navbar'

const theme = createTheme({
  palette: {
    primary: {
      main: '#4b0082' // indigo
    },
    secondary: {
      main: '#e6e6fa' // lavender
    }
  }
})

function App() {
  return (
    <ThemeProvider theme={theme}>
      <BrowserRouter>
        <Navbar />
        <Routes>
          <Route path="/" element={<Dashboard />} />
          <Route path="/policy/:id" element={<PolicyDetail />} />
        </Routes>
      </BrowserRouter>
    </ThemeProvider>
  )
}

export default App
