import { useState } from 'react'
import { Box, Grid, Paper, TextField, Typography } from '@mui/material'
import PolicyCard from '../components/PolicyCard'
import { mockPolicies } from '../data/mockData'

export default function Dashboard() {
  const [searchTerm, setSearchTerm] = useState('')

  const filteredPolicies = mockPolicies.filter(policy =>
    policy.title.toLowerCase().includes(searchTerm.toLowerCase()) ||
    policy.category.toLowerCase().includes(searchTerm.toLowerCase())
  )

  return (
    <Box sx={{ p: 3 }}>
      <Typography variant="h4" gutterBottom>
        Regulatory Policies
      </Typography>
      
      <TextField
        label="Search Policies"
        variant="outlined"
        fullWidth
        sx={{ mb: 3 }}
        value={searchTerm}
        onChange={(e) => setSearchTerm(e.target.value)}
      />

      <Grid container spacing={3}>
        {filteredPolicies.map((policy) => (
          <Grid item xs={12} sm={6} md={4} key={policy.id}>
            <PolicyCard policy={policy} />
          </Grid>
        ))}
      </Grid>
    </Box>
  )
}
