import { Routes, Route } from 'react-router-dom'
import TradingDashboard from './components/TradingDashboard'
import AccountManagement from './components/AccountManagement'
import TradingHistory from './components/TradingHistory'
import Navbar from './components/Navbar'
import './App.css'

function App() {
  return (
    <div className="app">
      <Navbar />
      <Routes>
        <Route path="/" element={<TradingDashboard />} />
        <Route path="/account" element={<AccountManagement />} />
        <Route path="/history" element={<TradingHistory />} />
      </Routes>
    </div>
  )
}

export default App
