import { useState } from 'react'
import '../App.css'

export default function AccountManagement() {
  const [balance, setBalance] = useState(10000.00)
  const [depositAmount, setDepositAmount] = useState('')
  const [withdrawAmount, setWithdrawAmount] = useState('')

  const handleDeposit = () => {
    setBalance(prev => prev + parseFloat(depositAmount))
    setDepositAmount('')
  }

  const handleWithdraw = () => {
    setBalance(prev => prev - parseFloat(withdrawAmount))
    setWithdrawAmount('')
  }

  return (
    <div className="component">
      <h2>Account Management</h2>
      <div className="account-info">
        <h3>Current Balance: ${balance.toFixed(2)}</h3>
        <div className="transaction">
          <input
            type="number"
            value={depositAmount}
            onChange={(e) => setDepositAmount(e.target.value)}
            placeholder="Deposit amount"
          />
          <button onClick={handleDeposit}>Deposit</button>
        </div>
        <div className="transaction">
          <input
            type="number"
            value={withdrawAmount}
            onChange={(e) => setWithdrawAmount(e.target.value)}
            placeholder="Withdraw amount"
          />
          <button onClick={handleWithdraw}>Withdraw</button>
        </div>
      </div>
    </div>
  )
}
