import '../App.css'

export default function TradingHistory() {
  const [history] = useState([
    { id: 1, item: 'Tech Stock', action: 'Bid', amount: 150.25, date: '2023-11-15' },
    { id: 2, item: 'Energy Shares', action: 'Bid', amount: 75.50, date: '2023-11-14' },
    { id: 3, item: 'Commodity ETF', action: 'Bid', amount: 42.75, date: '2023-11-13' }
  ])

  return (
    <div className="component">
      <h2>Trading History</h2>
      <table>
        <thead>
          <tr>
            <th>Date</th>
            <th>Item</th>
            <th>Action</th>
            <th>Amount</th>
          </tr>
        </thead>
        <tbody>
          {history.map(record => (
            <tr key={record.id}>
              <td>{record.date}</td>
              <td>{record.item}</td>
              <td>{record.action}</td>
              <td>${record.amount.toFixed(2)}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  )
}
