const express = require('express')
const cors = require('cors')
const nodemailer = require('nodemailer')
const multer = require('multer')
const path = require('path')
const fs = require('fs')

const app = express()
const upload = multer({ dest: 'uploads/' })

app.use(cors())
app.use(express.json())

// Email configuration
const transporter = nodemailer.createTransport({
  service: 'gmail',
  auth: {
    user: process.env.EMAIL_USER,
    pass: process.env.EMAIL_PASS
  }
})

// API endpoints
app.post('/api/send', upload.array('attachments'), async (req, res) => {
  try {
    const { to, subject, body, templateId } = req.body
    
    const mailOptions = {
      from: process.env.EMAIL_USER,
      to,
      subject,
      html: body,
      attachments: req.files?.map(file => ({
        filename: file.originalname,
        path: file.path
      }))
    }

    await transporter.sendMail(mailOptions)
    
    // Clean up attachments
    req.files?.forEach(file => fs.unlinkSync(file.path))
    
    res.status(200).json({ message: 'Email sent successfully' })
  } catch (error) {
    res.status(500).json({ error: error.message })
  }
})

app.get('/api/sent', (req, res) => {
  // In a real app, this would query a database
  res.json([])
})

app.get('/api/templates', (req, res) => {
  // Sample templates
  res.json([
    { id: 1, name: 'Welcome Email', content: '<h1>Welcome!</h1><p>Thank you for joining us.</p>' },
    { id: 2, name: 'Newsletter', content: '<h1>Monthly Newsletter</h1><p>Here are our updates...</p>' }
  ])
})

app.get('/api/recipients', (req, res) => {
  // Sample recipients
  res.json([
    { id: 1, name: 'John Doe', email: 'john@example.com' },
    { id: 2, name: 'Jane Smith', email: 'jane@example.com' }
  ])
})

const PORT = process.env.PORT || 5000
app.listen(PORT, () => console.log(`Server running on port ${PORT}`))
