import { BrowserRouter, Routes, Route } from 'react-router-dom'
import { ThemeProvider, createTheme } from '@mui/material/styles'
import { CssBaseline } from '@mui/material'
import ComposeEmail from './components/ComposeEmail'
import SentEmails from './components/SentEmails'
import Templates from './components/Templates'
import Recipients from './components/Recipients'
import Navbar from './components/Navbar'

const theme = createTheme({
  palette: {
    background: {
      default: 'cornsilk'
    },
    primary: {
      main: 'peru'
    }
  }
})

function App() {
  return (
    <ThemeProvider theme={theme}>
      <CssBaseline />
      <BrowserRouter>
        <Navbar />
        <Routes>
          <Route path="/" element={<ComposeEmail />} />
          <Route path="/sent" element={<SentEmails />} />
          <Route path="/templates" element={<Templates />} />
          <Route path="/recipients" element={<Recipients />} />
        </Routes>
      </BrowserRouter>
    </ThemeProvider>
  )
}

export default App
