import React, { useState } from 'react'
import { Box, TextField, Button, Select, MenuItem, InputLabel, FormControl, Chip, Typography } from '@mui/material'
import { useTemplates } from '../hooks/useTemplates'
import { useRecipients } from '../hooks/useRecipients'

export default function ComposeEmail() {
  const [to, setTo] = useState([])
  const [subject, setSubject] = useState('')
  const [body, setBody] = useState('')
  const [selectedTemplate, setSelectedTemplate] = useState('')
  const [attachments, setAttachments] = useState([])
  
  const { templates } = useTemplates()
  const { recipients } = useRecipients()

  const handleSend = async () => {
    // Send email logic
  }

  return (
    <Box sx={{ p: 4 }}>
      <Typography variant="h4" gutterBottom>Compose Email</Typography>
      
      <FormControl fullWidth sx={{ mb: 2 }}>
        <InputLabel>Recipients</InputLabel>
        <Select
          multiple
          value={to}
          onChange={(e) => setTo(e.target.value)}
          renderValue={(selected) => (
            <Box sx={{ display: 'flex', flexWrap: 'wrap', gap: 0.5 }}>
              {selected.map((value) => (
                <Chip key={value} label={recipients.find(r => r.id === value)?.email} />
              ))}
            </Box>
          )}
        >
          {recipients.map((recipient) => (
            <MenuItem key={recipient.id} value={recipient.id}>
              {recipient.name} ({recipient.email})
            </MenuItem>
          ))}
        </Select>
      </FormControl>

      <TextField
        fullWidth
        label="Subject"
        value={subject}
        onChange={(e) => setSubject(e.target.value)}
        sx={{ mb: 2 }}
      />

      <FormControl fullWidth sx={{ mb: 2 }}>
        <InputLabel>Template</InputLabel>
        <Select
          value={selectedTemplate}
          onChange={(e) => {
            setSelectedTemplate(e.target.value)
            const template = templates.find(t => t.id === e.target.value)
            if (template) setBody(template.content)
          }}
        >
          <MenuItem value="">None</MenuItem>
          {templates.map((template) => (
            <MenuItem key={template.id} value={template.id}>
              {template.name}
            </MenuItem>
          ))}
        </Select>
      </FormControl>

      <TextField
        fullWidth
        multiline
        rows={10}
        label="Body"
        value={body}
        onChange={(e) => setBody(e.target.value)}
        sx={{ mb: 2 }}
      />

      <input
        type="file"
        multiple
        onChange={(e) => setAttachments([...e.target.files])}
      />

      <Button
        variant="contained"
        onClick={handleSend}
        sx={{ mt: 2 }}
      >
        Send Email
      </Button>
    </Box>
  )
}
