import { useState, useEffect } from 'react'

export function useRecipients() {
  const [recipients, setRecipients] = useState([])
  const [loading, setLoading] = useState(true)
  const [error, setError] = useState(null)

  useEffect(() => {
    const fetchRecipients = async () => {
      try {
        const response = await fetch('/api/recipients')
        const data = await response.json()
        setRecipients(data)
      } catch (err) {
        setError(err.message)
      } finally {
        setLoading(false)
      }
    }

    fetchRecipients()
  }, [])

  return { recipients, loading, error }
}
