import React, { useState, useEffect } from 'react';
import { BrowserRouter as Router, Routes, Route, Link } from 'react-router-dom';
import { styled } from '@mui/system';
import { 
  AppBar, Toolbar, Typography, Button, Container, Box, 
  CssBaseline, createTheme, ThemeProvider 
} from '@mui/material';

// Custom theme with specified colors
const theme = createTheme({
  palette: {
    background: {
      default: '#FAFAD2', // light goldenrod
    },
    primary: {
      main: '#6B8E23', // olive drab
    },
    secondary: {
      main: '#556B2F', // darker olive drab
    },
  },
});

const StyledLink = styled(Link)({
  textDecoration: 'none',
  color: 'inherit',
  margin: '0 10px',
});

// Import components
import RawMaterials from './components/RawMaterials';
import FinishedProducts from './components/FinishedProducts';
import Production from './components/Production';
import Customers from './components/Customers';
import Sales from './components/Sales';
import Reports from './components/Reports';

function App() {
  return (
    <ThemeProvider theme={theme}>
      <CssBaseline />
      <Router>
        <AppBar position="static" color="primary">
          <Toolbar>
            <Typography variant="h6" component="div" sx={{ flexGrow: 1 }}>
              Paper Cup Manufacturing System
            </Typography>
            <StyledLink to="/raw-materials">Raw Materials</StyledLink>
            <StyledLink to="/finished-products">Finished Products</StyledLink>
            <StyledLink to="/production">Production</StyledLink>
            <StyledLink to="/customers">Customers</StyledLink>
            <StyledLink to="/sales">Sales</StyledLink>
            <StyledLink to="/reports">Reports</StyledLink>
          </Toolbar>
        </AppBar>
        <Container maxWidth="lg" sx={{ mt: 4 }}>
          <Routes>
            <Route path="/raw-materials" element={<RawMaterials />} />
            <Route path="/finished-products" element={<FinishedProducts />} />
            <Route path="/production" element={<Production />} />
            <Route path="/customers" element={<Customers />} />
            <Route path="/sales" element={<Sales />} />
            <Route path="/reports" element={<Reports />} />
            <Route path="/" element={<RawMaterials />} />
          </Routes>
        </Container>
      </Router>
    </ThemeProvider>
  );
}

export default App;
