import express from 'express'
import cors from 'cors'
import bodyParser from 'body-parser'
import sqlite3 from 'sqlite3'

const app = express()
const port = 5000

app.use(cors())
app.use(bodyParser.json())

// Database setup
const db = new sqlite3.Database(':memory:')

// Initialize database
db.serialize(() => {
  db.run(`
    CREATE TABLE IF NOT EXISTS documents (
      id TEXT PRIMARY KEY,
      title TEXT,
      content TEXT,
      status TEXT,
      created_at DATETIME DEFAULT CURRENT_TIMESTAMP
    )
  `)
})

// Routes
app.get('/api/documents', (req, res) => {
  db.all('SELECT * FROM documents', [], (err, rows) => {
    if (err) {
      return res.status(500).json({ error: err.message })
    }
    res.json(rows)
  })
})

app.post('/api/documents', (req, res) => {
  const { id, title, content } = req.body
  db.run(
    'INSERT INTO documents (id, title, content, status) VALUES (?, ?, ?, ?)',
    [id, title, content, 'pending'],
    function (err) {
      if (err) {
        return res.status(500).json({ error: err.message })
      }
      res.json({ id: this.lastID })
    }
  )
})

app.listen(port, () => {
  console.log(`Server running on port ${port}`)
})
