import { BrowserRouter, Routes, Route } from 'react-router-dom'
import Layout from './components/Layout'
import Dashboard from './pages/Dashboard'
import OfficeManagement from './pages/OfficeManagement'
import Infrastructure from './pages/Infrastructure'
import Procurement from './pages/Procurement'
import Personnel from './pages/Personnel'
import Financial from './pages/Financial'
import DecisionMaking from './pages/DecisionMaking'
import Login from './pages/Login'

function App() {
  return (
    <BrowserRouter>
      <Routes>
        <Route path="/login" element={<Login />} />
        <Route path="/" element={<Layout />}>
          <Route index element={<Dashboard />} />
          <Route path="office" element={<OfficeManagement />} />
          <Route path="infrastructure" element={<Infrastructure />} />
          <Route path="procurement" element={<Procurement />} />
          <Route path="personnel" element={<Personnel />} />
          <Route path="financial" element={<Financial />} />
          <Route path="decision-making" element={<DecisionMaking />} />
        </Route>
      </Routes>
    </BrowserRouter>
  )
}

export default App
