import React from 'react'
import { Card, Table, Button, Space } from 'antd'
import { PlusOutlined } from '@ant-design/icons'

const OfficeManagement = () => {
  const columns = [
    {
      title: 'Document ID',
      dataIndex: 'id',
      key: 'id',
    },
    {
      title: 'Title',
      dataIndex: 'title',
      key: 'title',
    },
    {
      title: 'Status',
      dataIndex: 'status',
      key: 'status',
    },
    {
      title: 'Actions',
      key: 'actions',
      render: (_, record) => (
        <Space size="middle">
          <Button type="primary">View</Button>
          <Button>Edit</Button>
          <Button danger>Delete</Button>
        </Space>
      ),
    },
  ]

  const data = [
    {
      id: 'DOC-2023-001',
      title: 'Annual Report Draft',
      status: 'Pending Approval',
    },
    {
      id: 'DOC-2023-002',
      title: 'Meeting Minutes',
      status: 'Approved',
    },
  ]

  return (
    <Card title="Office Management">
      <div style={{ marginBottom: 16 }}>
        <Button type="primary" icon={<PlusOutlined />}>
          New Document
        </Button>
      </div>
      <Table columns={columns} dataSource={data} rowKey="id" />
    </Card>
  )
}

export default OfficeManagement
