import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import styled from 'styled-components'
import Snowfall from 'react-snowfall'
import Navbar from './components/Navbar'
import Home from './pages/Home'
import Barbers from './pages/Barbers'
import Services from './pages/Services'
import Notifications from './pages/Notifications'

const AppContainer = styled.div`
  background-color: #696969;
  min-height: 100vh;
  color: white;
  position: relative;
`

function App() {
  return (
    <AppContainer>
      <Snowfall />
      <Router>
        <Navbar />
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/barbers" element={<Barbers />} />
          <Route path="/services" element={<Services />} />
          <Route path="/notifications" element={<Notifications />} />
        </Routes>
      </Router>
    </AppContainer>
  )
}

export default App
