import { useState } from 'react'
import styled from 'styled-components'

const BarberContainer = styled.div`
  padding: 2rem;
`

const BarberList = styled.ul`
  list-style: none;
  padding: 0;
`

const BarberItem = styled.li`
  background-color: #555;
  padding: 1rem;
  margin-bottom: 1rem;
  border-radius: 4px;
`

const Form = styled.form`
  display: flex;
  flex-direction: column;
  gap: 1rem;
  margin-top: 2rem;
`

const Input = styled.input`
  padding: 0.5rem;
  border-radius: 4px;
  border: none;
`

const Button = styled.button`
  padding: 0.5rem 1rem;
  background-color: #4CAF50;
  color: white;
  border: none;
  border-radius: 4px;
  cursor: pointer;
`

export default function Barbers() {
  const [barbers, setBarbers] = useState([
    { id: 1, name: 'John Doe', specialty: 'Haircuts' },
    { id: 2, name: 'Jane Smith', specialty: 'Beard Trimming' }
  ])
  const [newBarber, setNewBarber] = useState({ name: '', specialty: '' })

  const handleAddBarber = (e) => {
    e.preventDefault()
    setBarbers([...barbers, { ...newBarber, id: Date.now() }])
    setNewBarber({ name: '', specialty: '' })
  }

  return (
    <BarberContainer>
      <h2>Our Barbers</h2>
      <BarberList>
        {barbers.map(barber => (
          <BarberItem key={barber.id}>
            <h3>{barber.name}</h3>
            <p>Specialty: {barber.specialty}</p>
          </BarberItem>
        ))}
      </BarberList>

      <h3>Add New Barber</h3>
      <Form onSubmit={handleAddBarber}>
        <Input
          type="text"
          placeholder="Barber name"
          value={newBarber.name}
          onChange={(e) => setNewBarber({ ...newBarber, name: e.target.value })}
          required
        />
        <Input
          type="text"
          placeholder="Specialty"
          value={newBarber.specialty}
          onChange={(e) => setNewBarber({ ...newBarber, specialty: e.target.value })}
          required
        />
        <Button type="submit">Add Barber</Button>
      </Form>
    </BarberContainer>
  )
}
