import { useState } from 'react'
import axios from 'axios'

const SurveyForm = () => {
  const [formData, setFormData] = useState({
    age: '',
    height: '',
    weight: '',
    medicalHistory: '',
    currentSymptoms: '',
    lifestyle: '',
    contactInfo: ''
  })
  const [submitted, setSubmitted] = useState(false)

  const handleChange = (e) => {
    const { name, value } = e.target
    setFormData(prev => ({ ...prev, [name]: value }))
  }

  const handleSubmit = async (e) => {
    e.preventDefault()
    try {
      await axios.post('http://localhost:3001/api/surveys', formData)
      setSubmitted(true)
    } catch (error) {
      console.error('Submission error:', error)
    }
  }

  if (submitted) {
    return (
      <div className="form-container">
        <h2>Thank You!</h2>
        <p>Your health survey has been submitted successfully.</p>
      </div>
    )
  }

  return (
    <div className="form-container">
      <h2>Women's Health Survey</h2>
      <form onSubmit={handleSubmit}>
        <label>Age:</label>
        <input type="number" name="age" value={formData.age} onChange={handleChange} required />

        <label>Height (cm):</label>
        <input type="number" name="height" value={formData.height} onChange={handleChange} required />

        <label>Weight (kg):</label>
        <input type="number" name="weight" value={formData.weight} onChange={handleChange} required />

        <label>Medical History:</label>
        <textarea name="medicalHistory" value={formData.medicalHistory} onChange={handleChange} />

        <label>Current Symptoms:</label>
        <textarea name="currentSymptoms" value={formData.currentSymptoms} onChange={handleChange} />

        <label>Lifestyle Information:</label>
        <textarea name="lifestyle" value={formData.lifestyle} onChange={handleChange} />

        <label>Contact Information:</label>
        <input type="text" name="contactInfo" value={formData.contactInfo} onChange={handleChange} required />

        <button type="submit">Submit Survey</button>
      </form>
    </div>
  )
}

export default SurveyForm
