import { Link } from 'react-router-dom'
import { FaSearch, FaUserPlus, FaBriefcase } from 'react-icons/fa'

export default function Home() {
  return (
    <main className="container mx-auto px-4 py-8">
      <section className="text-center mb-12">
        <h1 className="text-4xl font-bold text-forest-green mb-4">
          Connecting Skilled Workers with Great Opportunities
        </h1>
        <p className="text-xl mb-8 max-w-2xl mx-auto">
          Find your next blue-collar job or the perfect worker for your project
        </p>
        <div className="flex justify-center space-x-4">
          <Link to="/register" className="btn bg-forest-green flex items-center">
            <FaUserPlus className="mr-2" />
            Join as Worker
          </Link>
          <Link to="/jobs" className="btn bg-forest-green flex items-center">
            <FaBriefcase className="mr-2" />
            Post a Job
          </Link>
        </div>
      </section>

      <section className="grid md:grid-cols-3 gap-8 mb-12">
        <div className="bg-white p-6 rounded-lg shadow-md">
          <h3 className="text-xl font-semibold mb-3 text-forest-green">Construction</h3>
          <p>Find skilled construction workers for your projects</p>
        </div>
        <div className="bg-white p-6 rounded-lg shadow-md">
          <h3 className="text-xl font-semibold mb-3 text-forest-green">Plumbing</h3>
          <p>Connect with licensed plumbers in your area</p>
        </div>
        <div className="bg-white p-6 rounded-lg shadow-md">
          <h3 className="text-xl font-semibold mb-3 text-forest-green">Electrical</h3>
          <p>Hire certified electricians for any job</p>
        </div>
      </section>
    </main>
  )
}
