import { useState, useEffect } from 'react'
import { InternshipCard } from '../components'
import '../styles/Dashboard.css'

export const StudentDashboard = () => {
  const [internships, setInternships] = useState([])

  // Fetch internships from API
  useEffect(() => {
    // In a real app, this would be an API call
    const mockInternships = [
      {
        id: 1,
        title: 'Frontend Developer Intern',
        company: 'Tech Corp',
        description: 'Work on cutting edge React applications',
        requirements: 'React, JavaScript, CSS'
      }
    ]
    setInternships(mockInternships)
  }, [])

  return (
    <div className="dashboard">
      <h1>Available Internships</h1>
      <div className="internship-grid">
        {internships.map(internship => (
          <InternshipCard key={internship.id} internship={internship} />
        ))}
      </div>
    </div>
  )
}
