import { ChatBot } from 'react-simple-chatbot'

export default function Chatbot() {
  const steps = [
    {
      id: '1',
      message: 'Welcome to GIIS! How can I help you today?',
      trigger: '2'
    },
    {
      id: '2',
      options: [
        { value: 'courses', label: 'Course Information', trigger: '3' },
        { value: 'enrollment', label: 'Enrollment Process', trigger: '4' },
        { value: 'contact', label: 'Contact Support', trigger: '5' }
      ]
    },
    // ... more chatbot steps
  ]

  return (
    <div className="chatbot-container">
      <ChatBot 
        steps={steps}
        floating={true}
        headerTitle="GIIS Assistant"
        botAvatar="https://placehold.co/50x50/4b0082/white?text=GIIS"
      />
    </div>
  )
}
