import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import { ThemeProvider, createTheme } from '@mui/material/styles'
import CssBaseline from '@mui/material/CssBaseline'
import Home from './pages/Home'
import Courses from './pages/Courses'
import CourseDetail from './pages/CourseDetail'
import Assignments from './pages/Assignments'
import Grades from './pages/Grades'
import Navbar from './components/Navbar'

const theme = createTheme({
  palette: {
    background: {
      default: '#F0FFF0', // Honeydew
      paper: '#556B2F' // Dark Olive Green
    },
    primary: {
      main: '#556B2F' // Dark Olive Green
    },
    secondary: {
      main: '#F0FFF0' // Honeydew
    },
    text: {
      primary: '#000000',
      secondary: '#FFFFFF'
    }
  }
})

function App() {
  return (
    <ThemeProvider theme={theme}>
      <CssBaseline />
      <Router>
        <Navbar />
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/courses" element={<Courses />} />
          <Route path="/courses/:id" element={<CourseDetail />} />
          <Route path="/assignments" element={<Assignments />} />
          <Route path="/grades" element={<Grades />} />
        </Routes>
      </Router>
    </ThemeProvider>
  )
}

export default App
