import { ThemeProvider, createTheme } from '@mui/material/styles'
import { CssBaseline } from '@mui/material'
import { Routes, Route } from 'react-router-dom'
import HomePage from './pages/HomePage'
import StudentDashboard from './pages/StudentDashboard'
import ProviderDashboard from './pages/ProviderDashboard'
import AuthPage from './pages/AuthPage'

const theme = createTheme({
  palette: {
    background: {
      default: '#007fff' // Azure background
    },
    primary: {
      main: '#003366' // Midnight blue
    }
  }
})

function App() {
  return (
    <ThemeProvider theme={theme}>
      <CssBaseline />
      <Routes>
        <Route path="/" element={<HomePage />} />
        <Route path="/auth" element={<AuthPage />} />
        <Route path="/student" element={<StudentDashboard />} />
        <Route path="/provider" element={<ProviderDashboard />} />
      </Routes>
    </ThemeProvider>
  )
}

export default App
