import { Box, Button, Container, Typography } from '@mui/material'
import { useNavigate } from 'react-router-dom'

export default function HomePage() {
  const navigate = useNavigate()

  return (
    <Container maxWidth="lg">
      <Box sx={{ my: 4, textAlign: 'center' }}>
        <Typography variant="h2" component="h1" gutterBottom>
          Student Portal
        </Typography>
        <Typography variant="h5" gutterBottom>
          Connect with training providers that match your career goals
        </Typography>
        <Box sx={{ mt: 4 }}>
          <Button
            variant="contained"
            size="large"
            sx={{ mr: 2 }}
            onClick={() => navigate('/auth?type=student')}
          >
            Student Login
          </Button>
          <Button
            variant="contained"
            size="large"
            onClick={() => navigate('/auth?type=provider')}
          >
            Provider Login
          </Button>
        </Box>
      </Box>
    </Container>
  )
}
