import { useState } from 'react'

export default function Assessment() {
  const [answers, setAnswers] = useState({})
  const [currentQuestion, setCurrentQuestion] = useState(0)

  const questions = [
    "I prefer structured plans over spontaneous activities",
    "I enjoy deep philosophical discussions",
    "I'm more of a thinker than a feeler",
    "I prefer practical advice over theoretical concepts",
    "I like to take charge in group situations",
    "I'm comfortable with emotional vulnerability",
    "I prefer direct communication over subtle hints",
    "I learn best through hands-on experience",
    "I value independence over teamwork",
    "I'm more focused on the big picture than details"
  ]

  const handleAnswer = (answer) => {
    setAnswers(prev => ({
      ...prev,
      [currentQuestion]: answer
    }))
    if (currentQuestion < questions.length - 1) {
      setCurrentQuestion(currentQuestion + 1)
    }
  }

  return (
    <div className="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-md border border-saddle-brown">
      <h1 className="text-3xl font-bold text-saddle-brown mb-6">Personality Assessment</h1>
      <div className="mb-6">
        <div className="h-2 bg-gray-200 rounded-full">
          <div 
            className="h-2 bg-saddle-brown rounded-full" 
            style={{ width: `${((currentQuestion + 1) / questions.length) * 100}%` }}
          ></div>
        </div>
        <p className="text-right mt-1 text-saddle-brown">
          Question {currentQuestion + 1} of {questions.length}
        </p>
      </div>
      <h2 className="text-xl font-semibold mb-6">{questions[currentQuestion]}</h2>
      <div className="flex justify-center space-x-4">
        <button 
          onClick={() => handleAnswer(1)}
          className="px-6 py-2 border border-saddle-brown text-saddle-brown rounded hover:bg-saddle-brown hover:text-white transition"
        >
          Strongly Disagree
        </button>
        <button 
          onClick={() => handleAnswer(5)}
          className="px-6 py-2 border border-saddle-brown text-saddle-brown rounded hover:bg-saddle-brown hover:text-white transition"
        >
          Strongly Agree
        </button>
      </div>
    </div>
  )
}
