import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import styled, { createGlobalStyle } from 'styled-components'
import Home from './pages/Home'
import Groups from './pages/Groups'
import Profile from './pages/Profile'
import GroupDetail from './pages/GroupDetail'
import CreateGroup from './pages/CreateGroup'
import Navbar from './components/Navbar'

const GlobalStyle = createGlobalStyle`
  * {
    box-sizing: border-box;
    margin: 0;
    padding: 0;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  }

  body {
    background-color: aliceblue;
    color: #333;
    line-height: 1.6;
  }

  a {
    text-decoration: none;
    color: inherit;
  }
`

const AppContainer = styled.div`
  min-height: 100vh;
  display: flex;
  flex-direction: column;
`

const MainContent = styled.main`
  flex: 1;
  padding: 30px;
  max-width: 1200px;
  width: 100%;
  margin: 0 auto;
`

function App() {
  return (
    <>
      <GlobalStyle />
      <AppContainer>
        <Router>
          <Navbar />
          <MainContent>
            <Routes>
              <Route path="/" element={<Home />} />
              <Route path="/groups" element={<Groups />} />
              <Route path="/groups/new" element={<CreateGroup />} />
              <Route path="/groups/:id" element={<GroupDetail />} />
              <Route path="/profile" element={<Profile />} />
            </Routes>
          </MainContent>
        </Router>
      </AppContainer>
    </>
  )
}

export default App
