import styled from 'styled-components'
import { Link } from 'react-router-dom'

const Card = styled.div`
  background-color: steelblue;
  color: white;
  padding: 20px;
  border-radius: 8px;
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
  transition: transform 0.2s;
  &:hover {
    transform: translateY(-5px);
  }
`

const CardTitle = styled.h3`
  margin-top: 0;
`

const CardLink = styled(Link)`
  color: white;
  text-decoration: none;
`

export default function GroupCard({ group }) {
  return (
    <Card>
      <CardLink to={`/groups/${group.id}`}>
        <CardTitle>{group.name}</CardTitle>
        <p>Members: {group.members}</p>
      </CardLink>
    </Card>
  )
}
